/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.itemstages.crt;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.zencode.impl.util.PositionUtil;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.darkhax.itemstages.Restriction;
import net.darkhax.itemstages.crt.actions.ActionCreateRestriction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraftforge.common.ToolType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.itemstages.ItemStages")
public class ZenItemStages {
    @ZenCodeType.Method
    public static Restriction restrict(ToolType type, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> stack.func_77973_b().getToolTypes(stack).contains(type), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(Enchantment enchantment, String ... requiredStages) {
        return ZenItemStages.restrict(enchantment, true, true, requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(Enchantment enchantment, boolean checkBook, boolean checkItem, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> ZenItemStages.hasEnchantment(stack, enchantment, checkBook, checkItem), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction createModRestriction(String modid, String ... requiredStages) {
        return ZenItemStages.createModRestriction(modid, null, requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction createModRestriction(String[] modids, String ... requiredStages) {
        return ZenItemStages.createModRestriction(modids, null, requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction createModRestriction(String modid, @Nullable Predicate<IItemStack> filter, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> modid.equalsIgnoreCase(stack.func_77973_b().getRegistryName().func_110624_b()) && (filter == null || !filter.test((IItemStack)new MCItemStack(stack))), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction createModRestriction(String[] modids, @Nullable Predicate<IItemStack> filter, String ... requiredStages) {
        Set restrictedModIds = Arrays.stream(modids).collect(Collectors.toSet());
        return ZenItemStages.restrictInternal(stack -> restrictedModIds.contains(stack.func_77973_b().getRegistryName().func_110624_b()) && (filter == null || !filter.test((IItemStack)new MCItemStack(stack))), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(Rarity rarity, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> stack.func_77953_t() == rarity, requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(IIngredient ingredient, String ... requiredStages) {
        return ZenItemStages.restrictInternal((Predicate<ItemStack>)ingredient.asVanillaIngredient(), requiredStages);
    }

    @ZenCodeType.Method
    public static Restriction restrict(Predicate<IItemStack> predicate, String ... requiredStages) {
        return ZenItemStages.restrictInternal(stack -> predicate.test((IItemStack)new MCItemStack(stack)), requiredStages);
    }

    private static Restriction restrictInternal(Predicate<ItemStack> condition, String[] requiredStages) {
        return ZenItemStages.create(requiredStages).restrict(condition);
    }

    @ZenCodeType.Method
    public static Restriction create(String ... requiredStages) {
        if (requiredStages.length == 0) {
            throw new IllegalStateException("[ItemStages] A restriction was created with no stages specified. This is not supported! " + PositionUtil.getZCScriptPositionFromStackTrace());
        }
        Restriction restriction = new Restriction(requiredStages);
        ActionCreateRestriction.apply(restriction);
        return restriction;
    }

    private static boolean hasEnchantment(ItemStack stack, Enchantment enchantment, boolean checkBook, boolean checkItem) {
        if (stack.func_77942_o()) {
            if (checkBook && stack.func_77973_b() instanceof EnchantedBookItem && EnchantmentHelper.func_82781_a((ItemStack)stack).getOrDefault(enchantment, 0) > 0) {
                return true;
            }
            if (checkItem && EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack) > 0) {
                return true;
            }
        }
        return false;
    }
}

